/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;

public class PermissionAction
extends BaseRestHandler {
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;

    public PermissionAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool) {
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/permission"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final List<String> permissions = Arrays.asList(request.paramAsStringArray("permissions", new String[0]));
        return new BaseRestHandler.RestChannelConsumer(){

            public void accept(RestChannel channel) throws Exception {
                User user = (User)PermissionAction.this.threadContext.getTransient("_sg_user");
                TransportAddress caller = Objects.requireNonNull((TransportAddress)PermissionAction.this.threadContext.getTransient("_sg_remote_address"));
                Map<String, Boolean> evaluationResult = PermissionAction.this.evaluator.evaluateClusterAndTenantPrivileges(user, caller, permissions);
                try (XContentBuilder builder = channel.newBuilder();){
                    builder.startObject();
                    builder.startObject("permissions");
                    for (String permission : permissions) {
                        builder.field(permission, evaluationResult.get(permission));
                    }
                    builder.endObject();
                    builder.endObject();
                    BytesRestResponse response = new BytesRestResponse(RestStatus.OK, builder);
                    channel.sendResponse((RestResponse)response);
                }
            }
        };
    }

    public String getName() {
        return "Permission Action";
    }
}

